Game_Interpreter.prototype.command302 = function() {
	$gameSwitches.setValue(179, false) //hide hud
	sset(117, true)
	$gameScreen.erasePicture(456)
    if (!$gameParty.inBattle()) {
        var goods = [this._params];
        while (this.nextEventCode() === 605) {
            this._index++;
            goods.push(this.currentCommand().parameters);
        }
        SceneManager.push(Scene_Shop);
        SceneManager.prepareNextScene(goods, this._params[4]);
    }
    return true;
};


Scene_Shop.prototype.create = function() {
    Scene_MenuBase.prototype.create.call(this);
	$gameSwitches.setValue(179, true) //show hud stats
	sset(117, true)
    this.createHelpWindow();
    this.createBuyWindow();
    this.createSellWindow();
    this.createNumberWindow();
		
		if (this._purchaseOnly) {//sell
			this._sellWindow._category = 'item'
			this.activateSellWindow()
			this._sellWindow.select(0);
		}
		else {
			this.activateBuyWindow()
		}

		if (ConfigManager.touchbuttons) {
			this.sprite = new Sprite(ImageManager.loadPicture('zBtnPrevNext'))
			this.sprite.visible = false
			this.addChild(this.sprite)
			
			this.spriteU = new Sprite(ImageManager.loadPicture('zBtnPrevNextU'))
			this.spriteU.visible = false
			this.addChild(this.spriteU)
			
			this.spriteD = new Sprite(ImageManager.loadPicture('zBtnPrevNextD'))
			this.spriteD.visible = false
			this.addChild(this.spriteD)
			
			this.spriteBack = new Sprite(ImageManager.loadPicture('zBtnBack'))
			this.spriteBack.visible = true
			this.spriteBack.x = -ConfigManager.movebtn //move x
			this.addChild(this.spriteBack)
			
			this.spriteInput = new Sprite(ImageManager.loadPicture('zBtnNumberInputs'))
			this.spriteInput.visible = false
			this.addChild(this.spriteInput)
		}
		
		$gameScreen.erasePicture(566) //erase clothing preview
		$gameScreen.erasePicture(128)
		$gameScreen.erasePicture(565)
		$gameScreen.erasePicture(564)
		
};

var nk_Scene_Shop_updatebtns = Scene_Shop.prototype.update
Scene_Shop.prototype.update = function() {
	nk_Scene_Shop_updatebtns.call(this)

	if (ConfigManager.touchbuttons && (this._sellWindow || this._buyWindow)) {
		var topRow
		var maxTopRow
		
		if (this._sellWindow.active) {
			topRow = this._sellWindow.topRow();
			maxTopRow = this._sellWindow.maxTopRow();
		}
		else {
			topRow = this._buyWindow.topRow();
			maxTopRow = this._buyWindow.maxTopRow();
		}
		
		if (maxTopRow > 0 && topRow < maxTopRow && topRow > 0) {
			this.sprite.visible = true
			this.spriteU.visible = false
			this.spriteD.visible = false
		}
		else if (topRow > 0) {
			this.sprite.visible = false
			this.spriteU.visible = true
			this.spriteD.visible = false
		}
		else if (maxTopRow > 0 && topRow < maxTopRow) {
			this.sprite.visible = false
			this.spriteU.visible = false
			this.spriteD.visible = true
		}
		else {
			this.sprite.visible = false
			this.spriteU.visible = false
			this.spriteD.visible = false
		}
	}

}
	
	

Window_ShopNumber.prototype.createButtons = function() {
}

Window_ShopNumber.prototype.setup = function(item, max, price) {
    this._item = item;
    this._max = Math.floor(max);
    this._price = price;
    this._number = 1;
    this.refresh();
};


Window_ShopSell.prototype.maxCols = function() {
    return 1;
};



Window_ShopSell.prototype.drawItem = function(index) {
    var item = this._data[index];
    var rect = this.itemRect(index);
    var priceWidth = 96;
    rect.width -= this.textPadding();
    this.changePaintOpacity(this.isEnabled(item));
	if (Utils.isMobileDevice()) {this.contents.fontSize = 20}
    this.drawItemName(item, rect.x, rect.y, rect.width - priceWidth);
		
	var amt = $gameParty.numItems(item)
	
	if (DataManager.isArmor(item)) {
		for (var i = 0; i < $gameActors.actor(1).equips().length; i++) {
			if ($gameActors.actor(1).equips()[i]) {
				if ($gameActors.actor(1).equips()[i].id == item.id) {
					amt += 1
				}
			}
		}
	}
	
	if (amt <= 9) {amt = " " + amt.toString()}
	
	var stored = " "
	if ($gameVariables.value(134).includes(item.id)) {stored = "*"}
	

    this.drawText("[x" + amt + "]" + stored, rect.x + rect.width - priceWidth, rect.y + 16, priceWidth, 'right');
		
	var price = Math.floor(item.price/ 2).toString().replace(/\B(?=(\d{3})+(?!\d))/g, ",")
    this.drawText(price + "   ", rect.x + rect.width - priceWidth - 70,
                  rect.y + 16, priceWidth, 'right');
	this.changeTextColor(this.textColor(14));
    this.drawText("C ", rect.x + rect.width - priceWidth - 70, rect.y + 16, priceWidth, 'right');
	this.changeTextColor(this.normalColor());
    this.changePaintOpacity(true);
};




Scene_Shop.prototype.money = function() {
    return $gameParty.gold();
};

Scene_Shop.prototype.createBuyWindow = function() {
										//x, y, h
    this._buyWindow = new Window_ShopBuy(62, 27, 449, this._goods);
    this._buyWindow.setHelpWindow(this._helpWindow);
    this._buyWindow.setHandler('ok',     this.onBuyOk.bind(this));
    this._buyWindow.setHandler('cancel', this.closeShopMenu.bind(this));
    this.addWindow(this._buyWindow);
};

Scene_Shop.prototype.closeShopMenu = function() {
	$gameScreen.erasePicture(128)
	$gameScreen.erasePicture(565)
	$gameScreen.erasePicture(566)
	$gameScreen.erasePicture(564)
  $gameTemp.reserveCommonEvent(26); //show menu btn
  this.popScene();
};

Window_ShopBuy.prototype.windowWidth = function() {
    return 692;
};

Scene_Shop.prototype.createSellWindow = function() {
    this._sellWindow = new Window_ShopSell(62, 28, 692, 448);
    this._sellWindow.setHelpWindow(this._helpWindow);
    this._sellWindow.hide();
    this._sellWindow.setHandler('ok',     this.onSellOk.bind(this));
    this._sellWindow.setHandler('cancel', this.closeShopMenu.bind(this));
    this.addWindow(this._sellWindow);
};


Window_ShopBuy.prototype.drawItem = function(index) {
    var item = this._data[index];
    var rect = this.itemRect(index);
    var priceWidth = 96;
    rect.width -= this.textPadding();
    this.changePaintOpacity(this.isEnabled(item));
	if (Utils.isMobileDevice()) {this.contents.fontSize = 20}
    this.drawItemName(item, rect.x, rect.y, rect.width - priceWidth);
		
	var amt = $gameParty.numItems(item)

	if (DataManager.isArmor(item)) {
		for (var i = 0; i < $gameActors.actor(1).equips().length; i++) {
			if ($gameActors.actor(1).equips()[i]) {
				if ($gameActors.actor(1).equips()[i].id == item.id) {
					amt += 1
				}
			}
		}
	}
	
	if (amt <= 9) {amt = " " + amt.toString()}
	
	var stored = " "
	if ($gameVariables.value(134).includes(item.id)) {stored = "*"}
	
    this.drawText("[x" + amt + "]" + stored, rect.x + rect.width - priceWidth, rect.y + 16, priceWidth, 'right');
		
	var price = this.price(item).toString().replace(/\B(?=(\d{3})+(?!\d))/g, ",")
    this.drawText(price + "   ", rect.x + rect.width - priceWidth - 70,
                  rect.y + 16, priceWidth, 'right');
	this.changeTextColor(this.systemColor());
    this.drawText("C ", rect.x + rect.width - priceWidth - 70, rect.y + 16, priceWidth, 'right');
	this.changeTextColor(this.normalColor());
    this.changePaintOpacity(true);
};

Scene_Shop.prototype.createNumberWindow = function() {
    this._numberWindow = new Window_ShopNumber(242, 180, 135); //x y height
    this._numberWindow.hide();
    this._numberWindow.setHandler('ok',     this.onNumberOk.bind(this));
    this._numberWindow.setHandler('cancel', this.onNumberCancel.bind(this));
    this.addWindow(this._numberWindow);
};

Window_ShopNumber.prototype.windowWidth = function() {
    return 332;
};

Window_ShopNumber.prototype.refresh = function() {
    this.contents.clear();
    this.drawItemName(this._item, -6, -10);

	//draw multiplication sign
    var sign = '\u00d7';
    var width = this.textWidth(sign);
    var x = this.cursorX() - width * 2;
    var y = this.itemY();
    this.resetTextColor();
    this.drawText(sign, x, y, width);
	
	//draw number
    var x = this.cursorX();
    var y = this.itemY();
    var width = this.cursorWidth() - this.textPadding();
    this.resetTextColor();
    this.drawText(this._number, x, y, width, 'right');
	
	//draw total price
    var total = this._price * this._number;
    var width = this.contentsWidth() - this.textPadding();
    this.drawCurrencyValue(total, this._currencyUnit, 0, this.priceY(), width);
};

Window_ShopNumber.prototype.itemY = function() {    return 36};
Window_ShopNumber.prototype.priceY = function() {    return 72};

Window_ShopNumber.prototype.processNumberChange = function() {
    if (this.isOpenAndActive()) {
        if (Input.isRepeated('right')) {
            this.changeNumber(1);
        }
        if (Input.isRepeated('left')) {
            this.changeNumber(-1);
        }
        if (Input.isRepeated('up') || Input.isRepeated('pageup')) {
            this.changeNumber(10);
        }
        if (Input.isRepeated('down') || Input.isRepeated('pagedown')) {
            this.changeNumber(-10);
        }
    }
};

Window_ShopNumber.prototype.drawCurrencyValue = function(value, unit, x, y, width) {
    var unitWidth = Math.min(80, this.textWidth(unit));
    this.resetTextColor();
		
		value = value.toString().replace(/\B(?=(\d{3})+(?!\d))/g, ",")
		
    this.drawText(value, x, y, width - unitWidth - 6, 'right');
    this.changeTextColor(this.systemColor());
    this.drawText(unit, x + width - unitWidth, y, unitWidth, 'right');
};


Scene_Shop.prototype.activateSellWindow = function() {
    this._sellWindow.refresh();
    this._sellWindow.show();
    this._sellWindow.activate();
};

Scene_Shop.prototype.activateBuyWindow = function() {
    this._buyWindow.setMoney(this.money());
    this._buyWindow.show();
    this._buyWindow.activate();
};

Scene_Shop.prototype.commandBuy = function() {
    this._buyWindow.setMoney(this.money());
    this._buyWindow.show();
    this._buyWindow.activate();
};

Scene_Shop.prototype.commandSell = function() {
    this._sellWindow.show();
    this._sellWindow.deselect();
    this._sellWindow.refresh();
};

Scene_Shop.prototype.onBuyOk = function() {
    this._item = this._buyWindow.item();
	
	if (Utils.isMobileDevice()) {
		if (DataManager.isArmor(this._item)) {
			previewclothes(this._item.etypeId - 2, this._item.note.match(/<filename:\s*(.*)>/i)[1], false, this._item.id)
		}
		else {
			$gameScreen.erasePicture(128)
			$gameScreen.erasePicture(564)
			$gameScreen.erasePicture(565)
			$gameScreen.erasePicture(566)
		}
	}
	
    this._numberWindow.setup(this._item, this.maxBuy(), this.buyingPrice());
    this._numberWindow.setCurrencyUnit(TextManager.currencyUnit);
    this._numberWindow.show();
    this._numberWindow.activate();
	if (ConfigManager.touchbuttons) {
		this.spriteInput.visible = true
	}
};



Scene_Shop.prototype.onSellOk = function() {
    this._item = this._sellWindow.item();
	
	if (Utils.isMobileDevice()) {
		if (DataManager.isArmor(this._item)) {
			previewclothes(this._item.etypeId - 2, this._item.note.match(/<filename:\s*(.*)>/i)[1], false, this._item.id)
		}
		else {
			$gameScreen.erasePicture(128)
			$gameScreen.erasePicture(564)
			$gameScreen.erasePicture(565)
			$gameScreen.erasePicture(566)
		}
	}
	
    this._numberWindow.setup(this._item, this.maxSell(), this.sellingPrice());
    this._numberWindow.setCurrencyUnit(TextManager.currencyUnit);
    this._numberWindow.show();
    this._numberWindow.activate();
		if (ConfigManager.touchbuttons) {
			this.spriteInput.visible = true
		}
};

/*
Scene_Shop.prototype.onCategoryOk = function() {
    this.activateSellWindow();
    this._sellWindow.select(0);
};
*/


Scene_Shop.prototype.onNumberOk = function() {
    SoundManager.playShop();
		if (this._purchaseOnly) {//sell
			this.doSell(this._numberWindow.number())
		}
		else {
			this.doBuy(this._numberWindow.number())
		}
	$gameSwitches.setValue(117, true)
    this.endNumberInput();
};


Scene_Shop.prototype.endNumberInput = function() {
    this._numberWindow.hide();
		
		if (this._purchaseOnly) {//sell
			this.activateSellWindow()
		}
		else {
			this.activateBuyWindow()
		}
		
		if (ConfigManager.touchbuttons) {
			this.spriteInput.visible = false
		}
};


Window_ShopBuy.prototype.processCursorMove = function() {
    if (this.isCursorMovable()) {
        var lastIndex = this.index();
        if (Input.isRepeated('down')) {
            this.cursorDown(Input.isTriggered('down'));
        }
        if (Input.isRepeated('up')) {
            this.cursorUp(Input.isTriggered('up'));
        }
        if (Input.isRepeated('right')) {
            this.cursorRight(Input.isTriggered('right'));
        }
        if (Input.isRepeated('left')) {
            this.cursorLeft(Input.isTriggered('left'));
        }
        if (!this.isHandled('pagedown') && Input.isRepeated('pagedown')) {
            this.cursorPagedown();
        }
        if (!this.isHandled('pageup') && Input.isRepeated('pageup')) {
            this.cursorPageup();
        }
        if (this.index() !== lastIndex) {
            SoundManager.playCursor();
        }
				
			if (DataManager.isArmor(this.item())) {
				previewclothes(this.item().etypeId - 2, this.item().note.match(/<filename:\s*(.*)>/i)[1], false, this.item().id)
			}
			else {
				$gameScreen.erasePicture(128)
				$gameScreen.erasePicture(564)
				$gameScreen.erasePicture(565)
				$gameScreen.erasePicture(566)
			}
    }
};


previewclothes = function(slotno, filename, flip = false, itemid) {
	filename = filename.match(/\D*/)

	var y = -274
	var yscale = 100
	var x = 819
	var xscale = 100
	
	if ($gameVariables.value(101) == 0) {
		y = -180
		yscale = 90
	}
	else if ($gameVariables.value(101) == 1) {
		y = -227
		yscale = 95
	}
	else if ($gameVariables.value(101) == 3) {
		y = -321
		yscale = 105
	}
	
	if (flip) {
		x = 1121
		xscale = -100
	}
	
	$gameScreen.erasePicture(128)
	$gameScreen.erasePicture(564)
	$gameScreen.erasePicture(565)
	$gameScreen.erasePicture(566)
	
	if (ConfigManager.port) {
		vset(340, [0,0,0,0])
		
		var pict = 566

		switch (slotno) {
		case 0:
			if ($dataArmors[itemid].note.match("<wheadback>")) {
				$gameScreen.showPicture(128, "whead-" + filename + "1", 0, x, y, xscale, yscale, 255, 0);
				pict = 134
			}
			else {
				$gameScreen.showPicture(566, "whead-" + filename + "1", 0, x, y, xscale, yscale, 255, 0);
			}
			if ($dataArmors[itemid].note.match("<wheadcolor")) {
				wheadcolor = $dataArmors[itemid].note.match(/<wheadcolor:\s*(.*)>/i)
				wheadcolor = wheadcolor[1].split(" ")
				for (var j = 0; j < wheadcolor.length; j++) {
					v(340)[j] = wheadcolor[j]
				}
			}
			break;
		case 1:
			$gameScreen.showPicture(566, "wface-" + filename + "1", 0, x, y, xscale, yscale, 255, 0);
			break;
		case 2:
		case 3:
			$gameScreen.showPicture(566, "wear-" + filename + "1", 0, x, y, xscale, yscale, 255, 0);
			break;
		case 4:
			$gameScreen.showPicture(566, "wneck-" + filename + "1", 0, x, y, xscale, yscale, 255, 0);
			if ($dataArmors[itemid].note.match("<wneckback>")) {
				$gameScreen.showPicture(565, "wneckback-" + filename + "1", 0, x, y, xscale, yscale, 255, 0);
			}
			break;
		case 5:
			$gameScreen.showPicture(566, "wnips-" + filename + "1a", 0, x, y, xscale, yscale, 255, 0);
			break;
		case 6:
			$gameScreen.showPicture(566, "wupperu-" + filename + "1", 0, x, y, xscale, yscale, 255, 0);
			if ($dataArmors[itemid].note.match("<onepiece>")) {
				$gameScreen.showPicture(565, "wloweru-" + filename + "1", 0, x, y, xscale, yscale, 255, 0);
			}
			if ($dataArmors[itemid].note.match("<sleeves>")) {
				$gameScreen.showPicture(564, "wupperusleeves-" + filename + "1", 0, x, y, xscale, yscale, 255, 0);
			}
			if ($dataArmors[itemid].note.match("<wupperucolor")) {
				wupperucolor = $dataArmors[itemid].note.match(/<wupperucolor:\s*(.*)>/i)
				wupperucolor = wupperucolor[1].split(" ")
				for (var j = 0; j < wupperucolor.length; j++) {
					v(340)[j] = wupperucolor[j]
				}
			}
			break;
		case 7:
			$gameScreen.showPicture(566, "wupper-" + filename + "1", 0, x, y, xscale, yscale, 255, 0);
			if ($dataArmors[itemid].note.match("<wupperb>")) {
				$gameScreen.showPicture(565, "wupperb-" + filename + "1", 0, x, y, xscale, yscale, 255, 0);
			}
			else if ($dataArmors[itemid].note.match("<onepieceouter>")) {
				$gameScreen.showPicture(565, "wlower-" + filename + "1", 0, x, y, xscale, yscale, 255, 0);
			}
			if ($dataArmors[itemid].note.match("<hood>")) {
				$gameScreen.showPicture(564, "whoodb-" + filename + "1", 0, x, y, xscale, yscale, 255, 0);
			}
			break;
		case 8:
		case 9:
			$gameScreen.showPicture(565, "whand-" + filename + "1", 0, x, y, xscale, yscale, 255, 0);
			if (!$dataArmors[itemid].note.match("<nohandover>")) {
				$gameScreen.showPicture(566, "whandover-" + filename + "1", 0, x, y, xscale, yscale, 255, 0);
			}
			break;
		case 10:
			$gameScreen.showPicture(566, "wcock-" + filename + "1" + "b", 0, x, y, xscale, yscale, 255, 0);
			break;
		case 11:
			$gameScreen.showPicture(566, "wballs-" + filename + "1", 0, x, y, xscale, yscale, 255, 0);
			break;
		case 12:
			$gameScreen.showPicture(566, "wpussy-" + filename + "1", 0, x, y, xscale, yscale, 255, 0);
			break;
		case 13:
			$gameScreen.showPicture(566, "wass-" + filename + "1", 0, x, y, xscale, yscale, 255, 0);
			break;
		case 14:
			$gameScreen.showPicture(566, "wloweru-" + filename + "1", 0, x, y, xscale, yscale, 255, 0);
			if ($dataArmors[itemid].note.match("<wlowerucolor")) {
				wlowerucolor = $dataArmors[itemid].note.match(/<wlowerucolor:\s*(.*)>/i)
				wlowerucolor = wlowerucolor[1].split(" ")
				for (var j = 0; j < wlowerucolor.length; j++) {
					v(340)[j] = wlowerucolor[j]
				}
			}
			break;
		case 15:
			$gameScreen.showPicture(566, "wlower-" + filename + "1", 0, x, y, xscale, yscale, 255, 0);
			if ($dataArmors[itemid].note.match("<wlowerb>")) {
				$gameScreen.showPicture(565, "wlowerb-" + filename + "1", 0, x, y, xscale, yscale, 255, 0);
			}
			if ($dataArmors[itemid].note.match("<wlowercolor")) {
				wlowercolor = $dataArmors[itemid].note.match(/<wlowercolor:\s*(.*)>/i)
				wlowercolor = wlowercolor[1].split(" ")
				for (var j = 0; j < wlowercolor.length; j++) {
					v(340)[j] = wlowercolor[j]
				}
			}
			break;
		case 16:
			$gameScreen.showPicture(566, "wfeetu-" + filename + "1", 0, x, y, xscale, yscale, 255, 0);
			break;
		case 17:
			$gameScreen.showPicture(565, "wfeet-" + filename + "1", 0, x, y, xscale, yscale, 255, 0);
			if ($dataArmors[itemid].note.match("<wfeettoes>")) {
				$gameScreen.showPicture(566, "wfeet-" + filename + "2", 0, x, y, xscale, yscale, 255, 0);
			}
			break;
		case 18:
		case 19:
			$gameScreen.showPicture(565, "wheld-" + filename + "1", 0, x, y, xscale, yscale, 255, 0);
			if ($dataArmors[itemid].note.match("<wheldover>")) {
				$gameScreen.showPicture(566, "wheldover-" + filename + "1", 0, x, y, xscale, yscale, 255, 0);
			}
			if ($dataArmors[itemid].note.match("<wheldunder>")) {
				$gameScreen.showPicture(564, "wheldunder-" + filename + "1", 0, x, y, xscale, yscale, 255, 0);
			}
			break;
		}
	}

	if (v(340)[0] == 1) {
		$gameScreen.tintPicture(pict, [0, 0, 0, 0], 0);
		$gameScreen.tintPicturePixiJS(pict, v(340)[1], v(340)[2], v(340)[3]);
	}
	else if (v(340)[0] == 2) {
		$gameScreen.tintPicture(pict, [v(340)[1], v(340)[2], v(340)[3], 0], 0)
		$gameScreen.tintPicturePixiJS(pict, 255, 255, 255);
	}

}



Window_ShopSell.prototype.isEnabled = function(item) {
    return (item && item.price != 0);
//    return (item && item.id != 2);
};
